EmployeeRunners.Completed[EmployeeTypeNames.LeadDeveloper] = ($rootScope, employee, task) => {
    $rootScope.settings.inventory[task.module.name] = ($rootScope.settings.inventory[task.module.name] || 0)+1;
    PlaySound(Sounds.produce);
    $rootScope.$broadcast(GameEvents.InventoryChange);

    if (task.autoRepeat && GetManagerWorkstationByEmployeeId(employee.id)) {
        let hasAllRequirements = Object.keys(task.module.requirements).every(componentName => {
            return ($rootScope.settings.inventory[componentName] || 0) >= task.module.requirements[componentName];
        });

        // If all components was available
        if (hasAllRequirements) {
            // Spent components
            Object.keys(task.module.requirements).forEach(componentName => {
                $rootScope.settings.inventory[componentName] -= task.module.requirements[componentName];
            });

            task.state = Enums.TaskStates.Running;
        } else {
            task.state = Enums.TaskStates.Stalled;
        }

        return;
    }
    employee.task = null;
};

EmployeeRunners.Stalled[EmployeeTypeNames.LeadDeveloper] = ($rootScope, employee, task) => {
    // Search new components
    let hasAllRequirements = Object.keys(task.module.requirements).every(componentName => {
        return ($rootScope.settings.inventory[componentName] || 0) >= task.module.requirements[componentName];
    });

    if (hasAllRequirements) {
        // Spent components
        Object.keys(task.module.requirements).forEach(componentName => {
            $rootScope.settings.inventory[componentName] -= task.module.requirements[componentName];
        });

        task.state = Enums.TaskStates.Running;
    }
};



